 ; Ŀ
 ;   Csv - read a csv/cdf file into a drawing, splitting lines at commas.  
 ;   Copyright 1996, 2005, 2007, 2010 by Rocket Software Ltd.              
 ;                                                                         
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len llen pos name1 strlst)
 ; Ŀ
 ;   First knock off leading spaces.  This prevents a string consisting    
 ;   only of spaces from getting into the main loop and crashing.          
 ; 
  (while (and (= (substr linn 1 1) " ")
              (/= (strlen linn) 0))
         (setq linn (substr linn 2)))
 ; Ŀ
 ;   Now process the string.  Note that the space remover is still         
 ;   required for leading spaces in individual fields.                     
 ; 
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")   ; character to split on
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= 0 (setq llen (strlen name1)))
                     (= (substr name1 llen) " "))
                (setq name1 (substr name1 1 (1- llen))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Mlix - returns the length of the longest sublist in a list.           
 ;   Arguments: Llist, a list of lists.                                    
 ;   Returns a number.                                                     
 ; 
 (DEFUN MLIX (llist / num sub strwid maxwid len maxlen)
  (setq num 0)
  (while (setq sub (nth num llist))
         (setq num (1+ num))
         (setq len (length sub))
         (if (or (null maxlen) (> len maxlen))
             (setq maxlen len)))
 maxlen)
 ; Ŀ
 ;   Mlix end.                                                             
 ; 

 ; Ŀ
 ;   Nook - remove commas from strings which excel has encapsulated in     
 ;   double quotes so that Csplit doesn't make one string into several.    
 ;   Takes one argument, the raw data string, returns it semi-processed.   
 ; 
 (DEFUN NOOK (linn / base pos nxchar inquot)
 ; Ŀ
 ;   Fields containing 38" are exported by Excel as "38""", so call Chug   
 ;   to change them to "38" which the cond section can handle.             
 ;   Later: """ is changed to |+", the cond section changes "38|+" to      
 ;   38|+ and the final insertion code must call Reinch to change this     
 ;   back to 38".                                                          
 ;   Similarly commas in double quotes are changed to ^| and after Csplit  
 ;   has chopped the string up into fields the attribute inserter calls    
 ;   Chug to change ^| back into a comma.                                  
 ; 
  (setq linn (car (chug "\"\"\"" "|+\"" linn)))
  (setq base "")
  (setq pos 1)
  (while (/= "" (setq nxchar (substr linn pos 1)))
         (setq pos (1+ pos))
         (cond ((and (null inquot) (= nxchar "\""))
                (setq inquot t))
               ((and inquot (= nxchar "\""))
                (setq inquot ()))
               ((and inquot (= nxchar ","))
                (setq base (strcat base "^|")))
               (t
                (setq base (strcat base nxchar)))))
 base)
 ; Ŀ
 ;   Nook end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Nthl - returns a list of the values at position num in     
 ;   a list of lists.                                                      
 ;   Arguments: Lists, a list of lists, ideally of text strings.           
 ;              Pos, the zero based position to extract.                   
 ;   Returns a list.                                                       
 ; 
 (DEFUN NTHL (lists pos / num sub gnulis vala)
  (setq num 0)
  (while (setq sub (nth num lists))
         (if (null (setq vala (nth pos sub)))
             (setq vala "-"))
         (setq gnulis (cons vala gnulis))
         (setq num (1+ num)))
 (reverse gnulis))
 ; Ŀ
 ;   Nthl end.                                                             
 ; 

 ; Ŀ
 ;   Reinch - Put back the commas and inch markers replaced by Nook.       
 ;   Arguments: Alist, a list of strings.                                  
 ;   Returns a list of strings.                                            
 ; 
 (DEFUN REINCH (alist / num sub gnu)
  (setq num 0)
  (while (setq sub (nth num alist))
         (setq num (1+ num))
         (setq sub (car (chug "^|" "," sub)))
         (setq sub (car (chug "|+" "\"" sub)))
         (setq gnu (append gnu (list sub))))
 gnu)
 ; Ŀ
 ;   Reinch end.                                                           
 ; 

 ; Ŀ
 ;   Twid - find the width of a hypothetical text string.                  
 ;   Takes one argument, the text entity data list.                        
 ;   Returns a width (a number).                                           
 ; 
 (DEFUN TWID (entt / tblist cc dd bwidth)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (- (car dd) (car cc))))
 ; Ŀ
 ;   Twid end.                                                             
 ; 

 ; Ŀ
 ;   Wix - returns the width of the widest text string in a list.          
 ;   Arguments: Llist, a list of text strngs.                              
 ;   Returns a value.                                                      
 ; 
 (DEFUN WIX (llist / num sub strwid maxwid)
  (setq num 0)
  (while (setq sub (nth num llist))
         (setq num (1+ num))
         (if (/= sub "")
             (setq strwid (twid (list (cons 1 sub) (cons 40 txht))))
             (setq strwid 0))
         (if (or (null maxwid) (> strwid maxwid))
             (setq maxwid strwid)))
 maxwid)
 ; Ŀ
 ;   Wix end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Xstraw - draw a column of left justified text.             
 ;   Arguments: Pa, the top insertion point.                               
 ;              Txht, the text height.                                     
 ;              Clear, the vertical spacing.                               
 ;              Strlst, the list of text strings.                          
 ;   Returns nothing.                                                      
 ; 
 (DEFUN XSTRAW (pa txht clear strlst / num str pa)
  (setq num 0)
  (while (setq str (nth num strlst))
         (setq num (1+ num))
         (command "text" pa txht 0 str)
         (setq pa (polar pa (* pi 1.5) clear)))
 (princ))
 ; Ŀ
 ;   Xstraw end.                                                           
 ; 

 ; Ŀ
 ;   Csv.                                                                  
 ; 
 (DEFUN C:CSV (/ *error* osmo dimsc txht clear filnam pa fn linn llist malist
                                                 num sub gnulis widmax widlst)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (setvar "osmode" osmo)
  (if shk (write-line shk))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, if Misps didn't load then fail gracefully.             
 ; 
  (if misps
      (setq dimsc (misps))
      (setq dimsc (getvar "dimscale")))
 ; Ŀ
 ;   Set up a few values.                                                  
 ; 
  (setq txht (* 2.5 dimsc))
  (setq clear (* 6 dimsc))
 ; Ŀ
 ;   Get a filename.                                                       
 ; 
  (setq filnam (getfiled "Comma Separated Data File"
                         (getvar "dwgprefix") "csv" 0))
 ; Ŀ
 ;   Get a start point.                                                    
 ; 
  (setq pa (getpoint "Upper left point: "))
 ; Ŀ
 ;   Open the file, read the file into a list of strings, close the file.  
 ; 
  (setq fn (open filnam "r"))
  (while (setq linn (read-line fn))
         (if (/= "" linn)
             (progn
                  (setq linn (nook linn))
                  (setq linn (csplit linn))
                  (setq linn (reinch linn))
                  (setq malist (cons linn malist)))))
  (close fn)
  (setq malist (reverse malist))
 ; Ŀ
 ;   Rearrange the list of lines into a list of columns.                   
 ; 
  (setq num 0)
  (repeat (mlix malist)
          (setq sub (nthl malist num))
          (setq gnulis (cons sub gnulis))
          (setq num (1+ num)))
 (setq gnulis (reverse gnulis))
 ; Ŀ
 ;   Find the maximum width of a line of text in each sublist, cons it     
 ;   to the sublist.                                                       
 ; 
  (setq num 0)
  (while (setq sub (nth num gnulis))
         (setq num (1+ num))
         (setq widmax (wix sub))
         (setq sub (cons widmax sub))
         (setq widlst (cons sub widlst)))
  (setq widlst (reverse widlst))
 ; Ŀ
 ;   Draw the columns of text.                                             
 ; 
  (setq num 0)
  (setvar "osmode" 0)
  (while (setq llist (nth num widlst))
         (xstraw pa txht clear (cdr llist))
         (setq pa (polar pa 0 (+ (car llist) (* clear 2))))
         (setq num (1+ num)))
 ; Ŀ
 ;   Restore sysvars, end.                                                 
 ; 
  (*error* ())
 (princ))